/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import slimeknights.mantle.util.BlockEntityHelper;

public class BaseContainerMenu<TILE extends class_2586>
extends class_1703 {
    public static double MAX_DISTANCE = 64.0;
    public static int BASE_Y_OFFSET = 84;
    @Nullable
    protected final TILE tile;
    @Nullable
    protected final class_1661 inv;
    protected int playerInventoryStart = -1;

    protected BaseContainerMenu(class_3917<?> type, int id, @Nullable class_1661 inv, @Nullable TILE tile) {
        super(type, id);
        this.inv = inv;
        this.tile = tile;
    }

    @Nullable
    public TILE getTile() {
        return this.tile;
    }

    public void syncOnOpen(class_3222 playerOpened) {
        class_3218 server = playerOpened.method_51469();
        for (class_1657 player : server.method_18456()) {
            if (player == playerOpened || !(player.field_7512 instanceof BaseContainerMenu) || !this.sameGui((BaseContainerMenu)player.field_7512)) continue;
            this.syncWithOtherContainer((BaseContainerMenu)player.field_7512, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    protected void syncWithOtherContainer(BaseContainerMenu otherContainer, class_3222 player) {
    }

    protected void syncNewContainer(class_3222 player) {
    }

    public boolean sameGui(BaseContainerMenu otherContainer) {
        if (this.tile == null) {
            return false;
        }
        return this.tile == otherContainer.tile;
    }

    public boolean method_7597(class_1657 playerIn) {
        if (this.tile == null) {
            return true;
        }
        if (!this.tile.method_11015()) {
            class_1937 world = this.tile.method_10997();
            if (world == null) {
                return false;
            }
            return world.method_8477(this.tile.method_11016());
        }
        return false;
    }

    public class_2371<class_1799> method_7602() {
        return super.method_7602();
    }

    protected void addInventorySlots() {
        if (this.inv != null) {
            this.addInventorySlots(this.inv);
        }
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected int getInventoryYOffset() {
        return BASE_Y_OFFSET;
    }

    protected void addInventorySlots(class_1661 inv) {
        int slotY;
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        int start = this.field_7761.size();
        for (slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.method_7621(new class_1735((class_1263)inv, slotX + slotY * 9 + 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (slotY = 0; slotY < 9; ++slotY) {
            this.method_7621(new class_1735((class_1263)inv, slotY, xOffset + slotY * 18, yOffset));
        }
        this.playerInventoryStart = start;
    }

    protected class_1735 method_7621(class_1735 slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new IllegalStateException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.method_7621(slotIn);
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return class_1799.field_8037;
        }
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            int end = this.field_7761.size();
            if (index < this.playerInventoryStart ? !this.method_7616(itemstack1, this.playerInventoryStart, end, true) : !this.method_7616(itemstack1, 0, this.playerInventoryStart, false)) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemstack;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.method_7960() && stack.method_7947() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(class_1799 stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.method_7947() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.method_7946()) {
            while (stack.method_7947() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(k);
                class_1799 itemstack1 = slot.method_7677();
                if (!itemstack1.method_7960() && itemstack1.method_7909() == stack.method_7909() && class_1799.method_31577((class_1799)stack, (class_1799)itemstack1) && this.method_7613(stack, slot)) {
                    int limit;
                    int l = itemstack1.method_7947() + stack.method_7947();
                    if (l <= (limit = Math.min(stack.method_7914(), slot.method_7676(stack)))) {
                        stack.method_7939(0);
                        itemstack1.method_7939(l);
                        slot.method_7668();
                        flag1 = true;
                    } else if (itemstack1.method_7947() < limit) {
                        stack.method_7934(limit - itemstack1.method_7947());
                        itemstack1.method_7939(limit);
                        slot.method_7668();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(class_1799 stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.method_7947() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            class_1735 slot = (class_1735)this.field_7761.get(k);
            class_1799 itemstack1 = slot.method_7677();
            if (itemstack1.method_7960() && slot.method_7680(stack) && this.method_7613(stack, slot)) {
                int limit = slot.method_7676(stack);
                class_1799 stack2 = stack.method_7972();
                if (stack2.method_7947() > limit) {
                    stack2.method_7939(limit);
                    stack.method_7934(limit);
                } else {
                    stack.method_7939(0);
                }
                slot.method_7673(stack2);
                slot.method_7668();
                flag1 = true;
                if (stack.method_7960()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    @Nullable
    public static <TILE extends class_2586> TILE getTileEntityFromBuf(@Nullable class_2540 buf, Class<TILE> type) {
        if (buf == null) {
            return null;
        }
        return (TILE)((class_2586)EnvExecutor.callWhenOn((EnvType)EnvType.CLIENT, () -> () -> BlockEntityHelper.get(type, (class_1922)class_310.method_1551().field_1687, buf.method_10811()).orElse(null)));
    }
}

